PSCAD 4.2.0

Settings
 {
 Id = "922686648.1144361511"
 Author = "reform.jayas"
 Desc = "Active Filter - series configuration"
 Arch = "windows"
 Options = 0
 Build = 22
 Warn = 1
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 1e-005
  Plot = 1e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "HLoad_1.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  freq = 50.0 [Hz]
  }

 }

Definitions
 {
 Component("moduloMR")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   Category("Configuration")
    {
    Input("Mdl",4,4,180,12,2)
     {
     Desc = "Modulo Factor"
     Def = "360.0"
     Data = Real
     Len = 15
     }
    }
   }

  Nodes = 
   {
   Input("in",-54,0)
    {
    Type = Real
    }
   Output("out",54,0)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-29,-29,29,29)
   Pen(ByNode,ByNode,ByNode,in)
   Line(-54,0,-29,0)
   Pen(,Solid)
   Line(-29,0,-35,6)
   Line(-29,0,-35,-6)
   Text(-45,-16,"")
   Pen(,ByNode,,out)
   Line(54,0,29,0)
   Text(0,-10,"Modulo")
   Text(0,12,"%Mdl")
   }

  Section(EMTDC)
   {
   Fortran = "      $out = MOD($in,$Mdl)"
   Branch = ""
   Computations = ""
   }
  }
 Component("AlphaBeta_ABC")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   Category("Parameters")
    {
    Choice("Mode",6,2,180,12,2)
     {
     Style = 0
     Desc = "Direction of Transformation:"
     Def = "0"
     Len = 15
     *0 = "ABC to AlphaBeta"
     *1 = "AlphaBeta to ABC"
     }
    Choice("Zero",6,16,180,12,2)
     {
     Style = 0
     Desc = "With Zero-Sequence Component"
     Def = "0"
     Len = 15
     *0 = "No"
     *1 = "Yes"
     }
    }
   }

  Nodes = 
   {
   Input("IALP",-72,-36)
    {
    Cond = "(Mode)"
    Type = Real
    }
   Input("IBET",-72,0)
    {
    Cond = "(Mode)"
    Type = Real
    }
   Input("ZER",-72,36)
    {
    Cond = "(Mode) && (Zero)"
    Type = Real
    }
   Output("IA",72,-36)
    {
    Cond = "(Mode)"
    Type = Real
    }
   Output("IB",72,0)
    {
    Cond = "(Mode)"
    Type = Real
    }
   Output("IC",72,36)
    {
    Cond = "(Mode)"
    Type = Real
    }
   Input("IA",-72,-36)
    {
    Cond = "!(Mode)"
    Type = Real
    }
   Input("IB",-72,0)
    {
    Cond = "!(Mode)"
    Type = Real
    }
   Input("IC",-72,36)
    {
    Cond = "!(Mode)"
    Type = Real
    }
   Output("IALP",72,-36)
    {
    Cond = "!(Mode)"
    Type = Real
    }
   Output("IBET",72,0)
    {
    Cond = "!(Mode)"
    Type = Real
    }
   Output("ZER",72,36)
    {
    Cond = "!(Mode) && (Zero)"
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-44,-45,45,44)
   Cond = "(Mode==1)"
   Line(-71,-36,-44,-36)
   Text(-63,-34,"Alpha")
   Line(-50,-41,-44,-36)
   Line(-44,-36,-50,-30)
   Line(72,-36,45,-36)
   Text(63,-34,"A")
   Line(-71,0,-44,0)
   Text(-63,1,"Beta")
   Line(-50,-5,-44,0)
   Line(-44,0,-50,5)
   Line(72,0,45,0)
   Text(63,1,"B")
   Line(72,35,45,35)
   Text(63,37,"C")
   Cond = "(Mode==1) && (Zero==1)"
   Line(-71,35,-44,35)
   Text(-63,37,"Zero")
   Line(-50,30,-44,35)
   Line(-44,35,-50,41)
   Cond = "(Mode==1)"
   Text(0,-6,"AlphaBeta")
   Text(0,6,"to")
   Text(0,16,"ABC")
   Cond = "(Mode==0)"
   Line(-71,-36,-44,-36)
   Text(-63,-34,"A")
   Line(-50,-41,-44,-36)
   Line(-44,-36,-50,-30)
   Line(72,-36,45,-36)
   Text(63,-34,"Alpha")
   Line(-71,0,-44,0)
   Text(-63,1,"B")
   Line(-50,-5,-44,0)
   Line(-44,0,-50,5)
   Line(72,0,45,0)
   Text(63,1,"Beta")
   Line(-71,35,-44,35)
   Text(-63,37,"C")
   Line(-50,30,-44,35)
   Line(-44,35,-50,41)
   Cond = "(Mode==0) && (Zero==1)"
   Line(72,35,45,35)
   Text(63,37,"Zero")
   Cond = "(Mode==0)"
   Text(0,-6,"ABC")
   Text(0,6,"to")
   Text(0,16,"AlphaBeta")
   }

  Section(EMTDC)
   {
   FORTRAN = "\
#SUBROUTINE ALBEABC AlphaBeta transformation
!
!  AlphaBeta transformation:
!
#IF Mode==1
!  ------------------------------------
!  Transformation from AlphaBeta to ABC
!  ------------------------------------
       $IA = SQRT(2.0/3.0)*$IALP
       $IB = SQRT(2.0/3.0)*0.5*(-$IALP + SQRT(3.0)*$IBET)
       $IC = SQRT(2.0/3.0)*0.5*(-$IALP - SQRT(3.0)*$IBET)
#IF Zero==1
       $IA = $IA + SQRT(2.0/3.0)*$ZER/SQRT(2.0)
       $IB = $IB + SQRT(2.0/3.0)*$ZER/SQRT(2.0)
       $IC = $IC + SQRT(2.0/3.0)*$ZER/SQRT(2.0)
#ENDIF
#ELSE
!  ------------------------------------
!  Transformation from ABC to AlphaBeta
!  ------------------------------------
       $IALP = SQRT(2.0/3.0)*0.5*(2.0*$IA - $IB - $IC)
       $IBET = SQRT(2.0/3.0)*SQRT(3.0)*0.5*($IB - $IC)
#IF Zero==1
       $ZER  = SQRT(2.0/3.0)*($IA + $IB + $IC)/SQRT(2.0)
#ENDIF
#ENDIF"
   FILES = "\
cbpwm.f
"
   }
  }
 Module("CtrlSystem")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,White)
   Rectangle(-26,-36,25,36)
   Text(0,-10,"Control")
   Text(0,3,"System")
   Text(0,16,"Page")
   }


  Page(A/A4,Portrait,16,[597,467],5)
   {
   0.mult([90,936],0,0,150)
    {
    }
   0.datalabel([54,936],2,0,-1)
    {
    Name = "Iaph"
    }
   0.datalabel([54,1008],2,0,-1)
    {
    Name = "Ibta"
    }
   -Wire-([54,972],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([162,972],0,0,250)
    {
    DPath = "1"
    A = "0"
    B = "-1"
    C = "0"
    D = "0"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([126,936],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([126,1008],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([54,972],2,0,-1)
    {
    Name = "Vbta"
    }
   -Wire-([198,972],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.cmplx([306,972],0,0,260)
    {
    G = "1.0"
    DR = "0.2"
    F = "35.0 [Hz]"
    HP = "1"
    MP = "0"
    LP = "0"
    }
   0.pgb([234,972],3,23122528,620)
    {
    Name = "q_inst"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.mult([90,1008],0,0,160)
    {
    }
   -Wire-([54,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([54,1044],2,0,-1)
    {
    Name = "Vaph"
    }
   0.mult([648,630],0,0,340)
    {
    }
   0.mult([648,702],0,0,350)
    {
    }
   -Wire-([612,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([612,738],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([720,666],0,0,380)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "-1"
    G = "0"
    }
   -Wire-([684,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([684,702],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([612,630],2,0,-1)
    {
    Name = "Vaph"
    }
   0.datalabel([612,666],2,0,-1)
    {
    Name = "Pinst"
    }
   0.datalabel([612,702],2,0,-1)
    {
    Name = "Vbta"
    }
   0.datalabel([612,738],2,0,-1)
    {
    Name = "Qinst"
    }
   0.mult([648,774],0,0,240)
    {
    }
   0.mult([648,846],0,0,360)
    {
    }
   -Wire-([612,810],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([612,882],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([720,810],0,0,400)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([684,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([684,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([612,810],2,0,-1)
    {
    Name = "Pinst"
    }
   0.datalabel([612,882],2,0,-1)
    {
    Name = "Qinst"
    }
   0.datalabel([612,774],2,0,-1)
    {
    Name = "Vbta"
    }
   0.datalabel([612,846],2,0,-1)
    {
    Name = "Vaph"
    }
   0.div([792,666],0,0,390)
    {
    }
   0.div([792,810],0,0,410)
    {
    }
   0.datalabel([792,702],0,0,-1)
    {
    Name = "a2pb2"
    }
   0.datalabel([792,846],0,0,-1)
    {
    Name = "a2pb2"
    }
   -Wire-([828,810],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([864,810],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([828,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([864,702],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1008,702],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1008,738],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1008,774],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([828,522],2,0,-1)
    {
    Name = "Vaph"
    }
   0.mult([864,522],0,0,100)
    {
    }
   0.datalabel([864,558],0,0,-1)
    {
    Name = "Vaph"
    }
   0.sumjct([936,558],0,0,200)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([900,522],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.mult([864,594],0,0,120)
    {
    }
   0.datalabel([828,594],2,0,-1)
    {
    Name = "Vbta"
    }
   0.datalabel([864,630],0,0,-1)
    {
    Name = "Vbta"
    }
   -Wire-([900,594],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([972,558],2,0,-1)
    {
    Name = "a2pb2"
    }
   0.gain([1062,702],0,0,440)
    {
    G = "K"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([1062,738],0,0,470)
    {
    G = "K"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([1062,774],0,0,430)
    {
    G = "K"
    COM = "Gain"
    Dim = "1"
    }
   0.var([1026,648],0,24627560,140)
    {
    Name = "SerAF_K"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "-50"
    Value = "40.0"
    Units = ""
    Collect = "1"
    }
   -Wire-([1062,648],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1080,648],2,0,-1)
    {
    Name = "K"
    }
   0.datalabel([1026,702],2,0,-1)
    {
    Name = "IaRef"
    }
   0.datalabel([1026,738],2,0,-1)
    {
    Name = "IbRef"
    }
   0.datalabel([1026,774],2,0,-1)
    {
    Name = "IcRef"
    }
   0.datalabel([1098,702],2,0,-1)
    {
    Name = "VaRef"
    }
   0.datalabel([1098,738],2,0,-1)
    {
    Name = "VbRef"
    }
   0.datalabel([1098,774],2,0,-1)
    {
    Name = "VcRef"
    }
   0.mult([90,648],0,0,110)
    {
    }
   0.datalabel([54,648],2,0,-1)
    {
    Name = "Iaph"
    }
   0.datalabel([54,684],2,0,-1)
    {
    Name = "Vaph"
    }
   0.mult([90,720],0,0,130)
    {
    }
   0.datalabel([54,720],2,0,-1)
    {
    Name = "Ibta"
    }
   0.datalabel([54,756],2,0,-1)
    {
    Name = "Vbta"
    }
   -Wire-([54,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([54,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.sumjct([162,684],0,0,210)
    {
    DPath = "1"
    A = "0"
    B = "1"
    C = "0"
    D = "0"
    E = "0"
    F = "1"
    G = "0"
    }
   -Wire-([126,648],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([126,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.cmplx([306,684],0,0,220)
    {
    G = "1.0"
    DR = "0.2"
    F = "35.0 [Hz]"
    HP = "1"
    MP = "0"
    LP = "0"
    }
   0.pgb([234,684],3,50987480,640)
    {
    Name = "p_inst"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([198,684],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.pgb([450,684],3,50988528,630)
    {
    Name = "p_inst filtered"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([414,684],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([486,684],2,0,-1)
    {
    Name = "Pinst"
    }
   0.cmplx([378,684],0,0,230)
    {
    G = "1.0"
    DR = "0.2"
    F = "2500 [Hz]"
    HP = "0"
    MP = "0"
    LP = "1"
    }
   0.pgb([450,972],3,50990376,610)
    {
    Name = "q_inst filtered"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([486,972],2,0,-1)
    {
    Name = "Qinst"
    }
   -Wire-([414,972],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.cmplx([378,972],0,0,270)
    {
    G = "1.0"
    DR = "0.2"
    F = "2500 [Hz]"
    HP = "0"
    MP = "0"
    LP = "1"
    }
   -Sticky-([72,504],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,504,252,576
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Calculation of  instantaneous real power based on alpha, beta quantities"
    }
   -Sticky-([342,504],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 342,504,522,576
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "After filtering of real power 'p' only ac component of the instantaneous  real power is left"
    }
   -Sticky-([72,792],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,792,252,864
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Calculation of instantaneous reactive power based on alpha, beta quantities"
    }
   -Sticky-([342,792],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 342,792,522,864
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "After filtering of reactive power 'q' only ac component of the instantaneous reactive power is left"
    }
   -Sticky-([594,504],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 594,504,774,576
    Alignment = 1
    Style = 1
    Arrow = 10
    Color = 0,15792890
    Text = "Calculation of  alpha, beta of current which become the reference current for active filter"
    }
   -Sticky-([882,828],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 882,828,990,900
    Alignment = 1
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "Transformation of alpha, beta currents into phase currents"
    }
   -Sticky-([1008,504],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1008,504,1116,576
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Reference currents which are fed into current control of active filter"
    }
   .AlphaBeta_ABC([936,738],0,0,420)
    {
    Mode = "1"
    Zero = "0"
    }
   0.datalabel([342,396],2,0,-1)
    {
    Name = "ISa"
    }
   0.datalabel([342,432],2,0,-1)
    {
    Name = "ISb"
    }
   0.datalabel([342,468],2,0,-1)
    {
    Name = "ISc"
    }
   -Wire-([342,396],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([342,432],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([342,468],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([90,396],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([90,432],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([90,468],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([90,396],2,0,-1)
    {
    Name = "Va"
    }
   0.datalabel([90,432],2,0,-1)
    {
    Name = "Vb"
    }
   0.datalabel([90,468],2,0,-1)
    {
    Name = "Vc"
    }
   0.datalabel([288,396],2,0,-1)
    {
    Name = "Vaph"
    }
   0.datalabel([288,432],2,0,-1)
    {
    Name = "Vbta"
    }
   0.datalabel([540,396],2,0,-1)
    {
    Name = "Iaph"
    }
   0.datalabel([540,432],2,0,-1)
    {
    Name = "Ibta"
    }
   -Wire-([504,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([504,432],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([252,432],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([252,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   .AlphaBeta_ABC([432,432],0,0,90)
    {
    Mode = "0"
    Zero = "0"
    }
   .AlphaBeta_ABC([180,432],0,0,80)
    {
    Mode = "0"
    Zero = "0"
    }
   0.var_switch([252,1170],2,25011584,180)
    {
    Name = "blocking"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "deblk"
    Toff = "blk"
    }
   0.fp_int([180,1350],0,0,540)
    {
    Type = "1"
    PNum = "1"
    Blck = "1"
    PFormat = "0"
    detect = "0"
    max = "360.0 [deg]"
    min = "0.0 [deg]"
    BType = "0"
    PTime = "0.005 [s]"
    }
   -Wire-([216,1206],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([126,1314],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([126,1350],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([126,1242],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([144,1278],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datalabel([126,1278],2,0,-1)
    {
    Name = "TrgOn"
    }
   0.datalabel([126,1350],2,0,-1)
    {
    Name = "TrgOff"
    }
   0.datalabel([126,1242],2,0,-1)
    {
    Name = "H_on"
    }
   0.datalabel([126,1314],2,0,-1)
    {
    Name = "H_off"
    }
   0.datamerge([1098,1170],4,0,510)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   0.gain([972,1098],0,0,460)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([972,1152],0,0,450)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([972,1206],0,0,500)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([1008,1080],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1008,1098],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1008,1134],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1008,1152],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1008,1188],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1008,1206],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1080,1080],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1080,1188],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1062,1170],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1062,1098],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1080,1116],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1080,1170],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1134,1224],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datamerge([1098,1350],4,0,530)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   0.gain([972,1260],0,0,490)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([972,1314],0,0,480)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   0.gain([972,1368],0,0,520)
    {
    G = "-1.0"
    COM = "Gain"
    Dim = "1"
    }
   -Wire-([1008,1260],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1008,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1008,1314],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1008,1332],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1008,1368],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1008,1386],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1080,1260],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1080,1368],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1062,1350],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1062,1278],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([1080,1296],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1080,1350],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1134,1404],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.datalabel([1134,1224],2,0,-1)
    {
    Name = "H_on"
    }
   0.datalabel([1134,1404],2,0,-1)
    {
    Name = "H_off"
    }
   0.datalabel([1008,1080],2,0,-1)
    {
    Name = "VaRef"
    }
   0.datalabel([936,1152],1,0,-1)
    {
    Name = "VaRef"
    }
   0.datalabel([1008,1134],2,0,-1)
    {
    Name = "VbRef"
    }
   0.datalabel([936,1206],1,0,-1)
    {
    Name = "VbRef"
    }
   0.datalabel([1008,1188],2,0,-1)
    {
    Name = "VcRef"
    }
   0.datalabel([936,1098],1,0,-1)
    {
    Name = "VcRef"
    }
   0.datalabel([936,1260],1,0,-1)
    {
    Name = "VaRef"
    }
   0.datalabel([1008,1332],0,0,-1)
    {
    Name = "VaRef"
    }
   0.datalabel([1008,1386],0,0,-1)
    {
    Name = "VbRef"
    }
   0.datalabel([936,1314],1,0,-1)
    {
    Name = "VbRef"
    }
   0.datalabel([1008,1278],0,0,-1)
    {
    Name = "VcRef"
    }
   0.datalabel([936,1368],1,0,-1)
    {
    Name = "VcRef"
    }
   -Sticky-([918,972],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 918,972,1098,1026
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "\
Control system of active filter:
Calculations of firing pulses"
    }
   -Sticky-([594,972],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 594,972,810,1026
    Alignment = 1
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "\
Control system of active filter:
Generation of triangular waveforms synchronized with system ac voltage"
    }
   0.mult([756,1116],0,0,290)
    {
    }
   0.nl_tfun([648,1278],0,0,310)
    {
    N = "4"
    x1 = "0.0"
    y1 = "0.0"
    x2 = "90.0"
    y2 = "1.0"
    x3 = "270.0"
    y3 = "-1.0"
    x4 = "360.0"
    y4 = "0.0"
    x5 = "0.0"
    y5 = "0.0"
    x6 = "1.0"
    y6 = "1.0"
    x7 = "2.0"
    y7 = "2.0"
    x8 = "3.0"
    y8 = "3.0"
    x9 = "4.0"
    y9 = "4.0"
    x10 = "5.0"
    y10 = "5.0"
    }
   -Wire-([612,1278],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datamerge([792,1278],4,0,370)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   -Wire-([720,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([720,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([720,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([720,1206],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([738,1224],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   -Wire-([738,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([738,1260],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([738,1296],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([792,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.nl_tfun([648,1350],0,0,320)
    {
    N = "4"
    x1 = "0.0"
    y1 = "0.0"
    x2 = "90.0"
    y2 = "-1.0"
    x3 = "270.0"
    y3 = "1.0"
    x4 = "360.0"
    y4 = "0.0"
    x5 = "0.0"
    y5 = "0.0"
    x6 = "1.0"
    y6 = "1.0"
    x7 = "2.0"
    y7 = "2.0"
    x8 = "3.0"
    y8 = "3.0"
    x9 = "4.0"
    y9 = "4.0"
    x10 = "5.0"
    y10 = "5.0"
    }
   -Wire-([720,1242],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([792,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datamerge([792,1422],4,0,330)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   -Wire-([720,1350],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([720,1422],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([720,1386],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([720,1350],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([738,1368],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([738,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([738,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([738,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([720,1350],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([702,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([702,1278],0,0,-1)
    {
    Vertex="0,0;0,162"
    }
   -Wire-([684,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([828,1332],2,0,-1)
    {
    Name = "TrgOn"
    }
   0.datalabel([828,1476],2,0,-1)
    {
    Name = "TrgOff"
    }
   0.const([792,1170],2,0,190)
    {
    Name = ""
    Value = "300.0"
    }
   -Wire-([594,1314],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([594,1188],0,0,-1)
    {
    Vertex="0,0;306,0"
    }
   -Wire-([900,1116],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([594,1188],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.datalabel([594,1080],0,0,-1)
    {
    Name = "Va"
    }
   0.datalabel([594,1116],0,0,-1)
    {
    Name = "Vb"
    }
   0.datalabel([594,1152],0,0,-1)
    {
    Name = "Vc"
    }
   -Wire-([594,1152],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([594,1116],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([594,1080],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.tvekt([648,1116],0,0,170)
    {
    Gp = "50.0"
    Gi = "500.0"
    Vbas = "100.0 [V]"
    Fbas = "$(freq)"
    Mode = "0"
    PMode = "1"
    FName = ""
    Err = ""
    }
   -Wire-([756,1152],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Sticky-([36,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 36,18,1206,90
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
ACTIVE FILTER SERIES CONFIGURATION
Control System Subpage"
    }
   0.radiolink([162,234],4,0,40)
    {
    Source = "Main"
    Name = "V"
    dim = "3"
    Mode = "0"
    Type = "0"
    }
   -Wire-([162,234],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([198,126],6,0,-1)
    {
    Name = "ISa"
    }
   0.datalabel([198,162],6,0,-1)
    {
    Name = "ISb"
    }
   0.datalabel([198,198],6,0,-1)
    {
    Name = "ISc"
    }
   -Wire-([198,126],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([198,162],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([198,198],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.radiolink([180,126],4,0,10)
    {
    Source = "Main"
    Name = "ISa"
    dim = "1"
    Mode = "0"
    Type = "0"
    }
   0.radiolink([180,162],4,0,20)
    {
    Source = "Main"
    Name = "ISb"
    dim = "1"
    Mode = "0"
    Type = "0"
    }
   0.radiolink([180,198],4,0,30)
    {
    Source = "Main"
    Name = "ISc"
    dim = "1"
    Mode = "0"
    Type = "0"
    }
   0.datalabel([270,1206],6,0,-1)
    {
    Name = "g1"
    }
   0.datalabel([270,1314],6,0,-1)
    {
    Name = "g4"
    }
   0.datalabel([270,1386],6,0,-1)
    {
    Name = "g6"
    }
   0.datalabel([270,1278],6,0,-1)
    {
    Name = "g3"
    }
   0.datalabel([270,1242],6,0,-1)
    {
    Name = "g2"
    }
   0.datalabel([270,1350],6,0,-1)
    {
    Name = "g5"
    }
   0.radiolink([288,1206],0,0,600)
    {
    Source = "Main"
    Name = "g1"
    dim = "2"
    Mode = "1"
    Type = "0"
    }
   0.radiolink([288,1242],0,0,590)
    {
    Source = "Main"
    Name = "g2"
    dim = "2"
    Mode = "1"
    Type = "0"
    }
   0.radiolink([288,1278],0,0,580)
    {
    Source = "Main"
    Name = "g3"
    dim = "2"
    Mode = "1"
    Type = "0"
    }
   0.radiolink([288,1314],0,0,570)
    {
    Source = "Main"
    Name = "g4"
    dim = "2"
    Mode = "1"
    Type = "0"
    }
   0.radiolink([288,1350],0,0,560)
    {
    Source = "Main"
    Name = "g5"
    dim = "2"
    Mode = "1"
    Type = "0"
    }
   0.radiolink([288,1386],0,0,550)
    {
    Source = "Main"
    Name = "g6"
    dim = "2"
    Mode = "1"
    Type = "0"
    }
   0.datalabel([774,324],0,0,-1)
    {
    Name = "IaRef"
    }
   0.pgb([810,324],0,25242120,700)
    {
    Name = "IaRef"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([774,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([774,360],0,0,-1)
    {
    Name = "IbRef"
    }
   0.pgb([810,360],0,22626008,680)
    {
    Name = "IbRef"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([774,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([774,396],0,0,-1)
    {
    Name = "IcRef"
    }
   0.pgb([810,396],0,22630544,660)
    {
    Name = "IcRef"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([774,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([900,324],0,0,-1)
    {
    Name = "VaRef"
    }
   0.pgb([936,324],0,24853344,690)
    {
    Name = "VaRef"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2"
    Max = "5"
    }
   -Wire-([900,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([900,360],0,0,-1)
    {
    Name = "VbRef"
    }
   0.pgb([936,360],0,24855976,670)
    {
    Name = "VbRef"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([900,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([900,396],0,0,-1)
    {
    Name = "VcRef"
    }
   0.pgb([936,396],0,25141056,650)
    {
    Name = "VcRef"
    Group = ""
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([900,396],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -ControlPanel-([882,126],0)
    {
    Name = "LOAD"
    Flags = 0
    State = 1
    Icon = 630,72
    Posn = 882,126
    Extents = 0,0,162,126
    Slider(24101512)
    Switch(24103600)
    }
   -ControlPanel-([702,126],0)
    {
    Name = "ACTIVE FILTER"
    Flags = 0
    State = 1
    Icon = 396,972
    Posn = 702,126
    Extents = 0,0,162,126
    Slider(24627560)
    Switch(25011584)
    }
   0.datatap([198,252],0,0,50)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([216,252],0,0,60)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([234,252],0,0,70)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([198,252],0,0,-1)
    {
    Name = "Va"
    }
   0.datalabel([216,252],0,0,-1)
    {
    Name = "Vb"
    }
   0.datalabel([234,252],0,0,-1)
    {
    Name = "Vc"
    }
   .moduloMR([846,1116],0,0,300)
    {
    Mdl = "360.0 "
    }
   -Sticky-([234,288],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 234,288,378,342
    Alignment = 1
    Style = 1
    Arrow = 192
    Color = 0,15792890
    Text = "Transformation of phase quantities into alpha, beta ones"
    }
   0.unity([180,1170],4,0,280)
    {
    IType = "2"
    OType = "1"
    }
   -Sticky-([288,144],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 288,144,432,198
    Alignment = 1
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "Signals received from Main Page"
    }
   -Wire-([216,1242],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([216,1278],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([216,1314],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([216,1350],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([216,1386],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   }
  }
 Module("RunTime")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,White)
   Rectangle(-25,-36,26,36)
   Line(-10,27,-10,2)
   Line(-14,24,15,24)
   Line(-10,23,-5,12)
   Line(-5,12,-2,19)
   Line(-2,19,2,8)
   Line(2,8,6,18)
   Line(6,18,12,3)
   Text(1,-15,"Graph")
   Text(1,-3,"Page")
   }


  Page(A/A4,Portrait,48,[597,467],100)
   {
   -Plot-([648,90],0)
    {
    Title = "system & load current"
    Draw = 1
    Area = [0,0,504,594]
    Posn = [648,90]
    Icon = [-1,-1]
    Extents = 0,0,504,594
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,504,177],"Ph A Current")
     {
     Options = 0
     Units = "kA"
     Curve(25589800,"ISa",0,,,)
     Curve(22730824,"Ia",1,,,)
     }
    Graph([0,177],[0,0,504,177],"Ph B Current")
     {
     Options = 0
     Units = "kA"
     Curve(23490608,"ISb",0,,,)
     Curve(22733792,"Ib",1,,,)
     }
    Graph([0,354],[0,0,504,177],"Ph C Current")
     {
     Options = 0
     Units = "kA"
     Curve(23493048,"ISc",0,,,)
     Curve(23802736,"Ic",1,,,)
     }
    }
   -Plot-([72,90],0)
    {
    Title = "DC Load"
    Draw = 1
    Area = [0,0,504,594]
    Posn = [72,90]
    Icon = [-1,-1]
    Extents = 0,0,504,594
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,504,266],"Voltage")
     {
     Options = 0
     Units = "kV"
     Curve(23145712,"Vdc_load",0,,,)
     }
    Graph([0,266],[0,0,504,265],"Current")
     {
     Options = 0
     Units = "kA"
     Curve(23148256,"Idc_load",0,,,)
     }
    }
   -Plot-([72,702],0)
    {
    Title = "phase A"
    Draw = 1
    Area = [0,0,1080,810]
    Posn = [72,702]
    Icon = [-1,-1]
    Extents = 0,0,1080,810
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,1080,214],"Current")
     {
     Options = 0
     Units = "kA"
     Curve(25589800,"ISa",0,,,)
     Curve(22730824,"Ia",1,,,)
     }
    Graph([0,214],[0,0,1080,214],"Voltage")
     {
     Options = 0
     Units = "kV"
     Curve(24758616,"VAFa",0,,,)
     Curve(24853344,"VaRef",1,,,)
     }
    PGraph([0,428],[0,0,1080,160],"PolyGraph")
     {
     Options = 2
     Curve(23151696,"S1(1)",0,,,1)
     }
    PGraph([0,588],[0,0,1080,159],"PolyGraph")
     {
     Options = 2
     Curve(23030240,"S4(1)",0,,,1)
     }
    }
   -Sticky-([18,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 18,18,1188,72
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
ACTIVE FILTER SERIES CONFIGURATION
Graph Subpage "
    }
   }
  }
 Module("Main")
  {
  Desc = " "
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Portrait,48,[597,467],100)
   {
   0.source3([144,540],0,0,50)
    {
    Name = "SRC"
    Type = "2"
    Ctrl = "0"
    MVA = "0.02 [MVA]"
    Vm = "0.2 [kV]"
    F = "$(freq)"
    Tc = "0.05 [s]"
    ZSeq = "0"
    Imp = "0"
    Exph = "0"
    View = "1"
    Term = "0"
    R1s = "0.002 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.0001 [H]"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    R0p = "1.0 [ohm]"
    L0p = "0.1 [H]"
    Z0 = "1.0 [ohm]"
    Phi0 = "80.0 [deg]"
    Es = "0.2 [kV]"
    F0 = "$(freq)"
    Ph = "0.0 [deg]"
    Pinit = "0.0 [pu]"
    Qinit = "0.0 [pu]"
    VCtrl = "0"
    Vdes = "1.0 [pu]"
    Vbase = "230.0 [kV]"
    Tvm = "0.02 [s]"
    Tvc = "0.05 [s]"
    PCtrl = "0"
    Pdes = "1.0 [pu]"
    Tpm = "0.02 [s]"
    Tpc = "0.05 [s]"
    P = ""
    Q = ""
    V = ""
    Theta = ""
    Ia = "ISa"
    Ib = "ISb"
    Ic = "ISc"
    }
   -Wire-([216,540],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([216,576],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([216,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([504,540],0,0,-1)
    {
    Vertex="0,0;252,0"
    }
   0.datalabel([558,900],0,0,-1)
    {
    Name = "g1"
    }
   0.datalabel([558,792],0,0,-1)
    {
    Name = "g4"
    }
   -Wire-([252,630],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([468,630],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([468,504],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([288,630],0,0,-1)
    {
    Vertex="0,0;180,0"
    }
   -Wire-([432,828],0,0,-1)
    {
    Vertex="0,0;0,-324"
    }
   -Wire-([396,684],0,0,-1)
    {
    Vertex="0,0;0,-180"
    }
   -Wire-([396,792],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([360,1080],0,0,-1)
    {
    Vertex="0,0;234,0"
    }
   -Wire-([252,1350],0,0,-1)
    {
    Vertex="0,0;234,0"
    }
   0.datalabel([450,1044],0,0,-1)
    {
    Name = "g3"
    }
   0.datalabel([558,1152],0,0,-1)
    {
    Name = "g3"
    }
   0.datalabel([450,1152],0,0,-1)
    {
    Name = "g6"
    }
   0.datalabel([558,1044],0,0,-1)
    {
    Name = "g6"
    }
   0.datalabel([450,1404],0,0,-1)
    {
    Name = "g2"
    }
   0.datalabel([558,1296],0,0,-1)
    {
    Name = "g2"
    }
   0.datalabel([450,1296],0,0,-1)
    {
    Name = "g5"
    }
   0.datalabel([558,1404],0,0,-1)
    {
    Name = "g5"
    }
   -Wire-([666,720],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.voltmetergnd([702,720],0,0,190)
    {
    Name = "VFdc"
    }
   -Wire-([684,1440],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([738,1440],0,0,-1)
    {
    Vertex="0,0;0,-504"
    }
   -Wire-([666,1224],0,0,-1)
    {
    Vertex="0,0;0,-504"
    }
   0.g6p200([900,540],0,0,800)
    {
    UP = "1"
    FP = "0"
    SNUB = "1"
    KV = "-2"
    View = "1"
    FR = "$(freq)"
    GP = "10.0"
    GI = "100.0"
    KP = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.001 [kV]"
    EBO = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    CD = "0.05 [uF]"
    RD = "5000.0 [ohm]"
    FPNM = ""
    VVolt = ""
    VCurr = ""
    SCurr = ""
    }
   -Wire-([900,450],0,0,-1)
    {
    Vertex="0,0;0,-18;108,-18"
    }
   -Wire-([738,432],0,0,-1)
    {
    Vertex="0,0;144,0;144,18"
    }
   0.var([1062,576],2,24101512,120)
    {
    Name = "angle"
    Group = "Pulse Bridge"
    Display = "0"
    Max = "90"
    Min = "0"
    Value = "15.0"
    Units = "deg"
    Collect = "1"
    }
   -Wire-([738,504],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.var_switch([1062,612],2,24103600,150)
    {
    Name = "blocking"
    Group = "Pulse Bridge"
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "deblk"
    Toff = "blk"
    }
   -Wire-([954,594],0,0,-1)
    {
    Vertex="0,0;0,18;36,18"
    }
   0.ground([900,630],1,0,-1)
    {
    }
   0.inductor([1116,540],1,0,-1)
    {
    L = "35 [mH]"
    }
   -Wire-([1116,540],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.ground([1116,612],1,0,-1)
    {
    }
   -Wire-([1116,612],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.resistor([1116,468],1,0,-1)
    {
    R = "2.5 [ohm]"
    }
   0.nodeloop([738,540],0,0,80)
    {
    View = "1"
    }
   0.xfmr-3p2w([810,540],0,0,100)
    {
    Name = "T1"
    Tmva = "0.02 [MVA]"
    f = "$(freq)"
    YD1 = "0"
    YD2 = "1"
    Lead = "1"
    Xl = "0.2 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0"
    View = "1"
    Dtls = "0"
    V1 = "0.2 [kV]"
    V2 = "0.2 [kV]"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0 [s]"
    Im1 = "1.0 [%]"
    ILA1 = "Ia"
    ILB1 = "Ib"
    ILC1 = "Ic"
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   -Wire-([558,486],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.capacitor([558,396],1,0,-1)
    {
    C = "340.0 [uF]"
    }
   0.capacitor([612,396],1,0,-1)
    {
    C = "170.0 [uF]"
    }
   0.capacitor([666,396],1,0,-1)
    {
    C = "300.0 [uF]"
    }
   -Wire-([612,486],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   -Wire-([558,486],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([666,486],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.inductor([558,324],1,0,-1)
    {
    L = "1.2 [mH]"
    }
   0.inductor([612,324],1,0,-1)
    {
    L = "1.2 [mH]"
    }
   0.inductor([666,324],1,0,-1)
    {
    L = "0.26 [mH]"
    }
   0.resistor([702,324],1,0,-1)
    {
    R = "3.0 [ohm]"
    }
   -Wire-([666,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([666,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([666,396],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([612,396],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([558,396],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.ground([612,324],3,0,-1)
    {
    }
   0.ammeter([558,522],3,0,60)
    {
    Name = "IF"
    }
   0.ammeter([396,720],3,0,170)
    {
    Name = "IaAF"
    }
   -Wire-([360,1080],0,0,-1)
    {
    Vertex="0,0;0,-468"
    }
   -Wire-([324,936],0,0,-1)
    {
    Vertex="0,0;0,-324"
    }
   -Wire-([252,1188],0,0,-1)
    {
    Vertex="0,0;0,-486"
    }
   -Wire-([288,1332],0,0,-1)
    {
    Vertex="0,0;0,-630"
    }
   0.inductor([252,1296],1,0,-1)
    {
    L = "1 [mH]"
    }
   0.capacitor([252,1260],0,0,-1)
    {
    C = "0.33 [uF]"
    }
   0.ammeter([252,1224],3,0,410)
    {
    Name = "IcAF"
    }
   -Wire-([252,1296],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.datalabel([90,882],0,0,-1)
    {
    Name = "ISa"
    }
   0.pgb([126,882],0,25589800,240)
    {
    Name = "ISa"
    Group = "System Current"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.15"
    Max = "0.15"
    }
   0.datalabel([90,918],0,0,-1)
    {
    Name = "ISb"
    }
   0.pgb([126,918],0,23490608,260)
    {
    Name = "ISb"
    Group = "System Current"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.15"
    Max = "0.15"
    }
   -Wire-([90,918],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([90,954],0,0,-1)
    {
    Name = "ISc"
    }
   0.pgb([126,954],0,23493048,290)
    {
    Name = "ISc"
    Group = "System Current"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.15"
    Max = "0.15"
    }
   -Wire-([90,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([324,1044],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.capacitor([324,990],0,0,-1)
    {
    C = "0.33 [uF]"
    }
   0.ammeter([324,972],3,0,300)
    {
    Name = "IbAF"
    }
   0.capacitor([396,738],0,0,-1)
    {
    C = "0.33 [uF]"
    }
   0.datalabel([90,1476],0,0,-1)
    {
    Name = "VFdc"
    }
   0.pgb([126,1476],0,23497832,520)
    {
    Name = "VFdc"
    Group = "DC Filter"
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([90,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([90,1512],0,0,-1)
    {
    Name = "IFdc"
    }
   0.pgb([126,1512],0,42737168,540)
    {
    Name = "IFdc"
    Group = "DC Filter"
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([90,1512],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.source1([738,864],1,0,-1)
    {
    Name = "dc2"
    Type = "1"
    Ctrl = "0"
    Vm = "0.4 [kV]"
    F = "60.0 [Hz]"
    Tc = "0.0 [s]"
    Imp = "0"
    ACDC = "1"
    Exph = "0"
    Term = "0"
    Es = "132.79056 [kV]"
    F0 = "60.0 [Hz]"
    Ph = "0.0 [deg]"
    Pac = "0.0 [MW]"
    Qac = "0.0 [MVAR]"
    Esd = "0.4 [kV]"
    Pdc = "0.0 [MW]"
    R1s = "0.001 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    Ia = ""
    }
   -Wire-([252,432],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   -Wire-([252,504],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   -Wire-([432,432],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.voltmeter([396,576],3,0,90)
    {
    Name = "VAFa"
    }
   0.voltmeter([324,684],3,0,140)
    {
    Name = "VAFb"
    }
   0.voltmeter([252,792],3,0,200)
    {
    Name = "VAFc"
    }
   0.datalabel([90,720],0,0,-1)
    {
    Name = "VAFa"
    }
   -Wire-([126,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([90,756],0,0,-1)
    {
    Name = "VAFb"
    }
   0.pgb([126,756],0,23071712,180)
    {
    Name = "VAFb"
    Group = "Active Filter Voltage"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([90,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([90,792],0,0,-1)
    {
    Name = "VAFc"
    }
   0.pgb([126,792],0,23074552,770)
    {
    Name = "VAFc"
    Group = "Active Filter Voltage"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([90,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.source1([738,792],1,0,230)
    {
    Name = "dc1"
    Type = "1"
    Ctrl = "0"
    Vm = "0.4 [kV]"
    F = "60.0 [Hz]"
    Tc = "0.0 [s]"
    Imp = "0"
    ACDC = "1"
    Exph = "0"
    Term = "0"
    Es = "132.79056 [kV]"
    F0 = "60.0 [Hz]"
    Ph = "0.0 [deg]"
    Pac = "0.0 [MW]"
    Qac = "0.0 [MVAR]"
    Esd = "0.4 [kV]"
    Pdc = "0.0 [MW]"
    R1s = "0.001 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    Ia = "IFdc"
    }
   0.xfmr-2w([324,576],7,0,-1)
    {
    Tmva = "1.0 [MVA]"
    f = "$(freq)"
    Xl = "0.01 [pu]"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Ideal = "0"
    Tap = "0"
    View = "2"
    V1 = "0.1 [kV]"
    V2 = "5.0 [kV]"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0 [s]"
    Im1 = "0.2 [%]"
    IL1 = ""
    IL2 = ""
    IMAG = ""
    FLUX = ""
    }
   0.xfmr-2w([396,468],7,0,-1)
    {
    Tmva = "1.0 [MVA]"
    f = "$(freq)"
    Xl = "0.01 [pu]"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Ideal = "0"
    Tap = "0"
    View = "2"
    V1 = "0.1 [kV]"
    V2 = "5.0 [kV]"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0 [s]"
    Im1 = "0.2 [%]"
    IL1 = ""
    IL2 = ""
    IMAG = ""
    FLUX = ""
    }
   0.xfmr-2w([252,666],7,0,-1)
    {
    Tmva = "1.0 [MVA]"
    f = "$(freq)"
    Xl = "0.01 [pu]"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Ideal = "0"
    Tap = "0"
    View = "2"
    V1 = "0.1 [kV]"
    V2 = "5.0 [kV]"
    Enab = "0"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0 [s]"
    Im1 = "0.2 [%]"
    IL1 = ""
    IL2 = ""
    IMAG = ""
    FLUX = ""
    }
   0.datalabel([90,1044],0,0,-1)
    {
    Name = "Ia"
    }
   0.pgb([126,1044],0,22730824,310)
    {
    Name = "Ia"
    Group = "Load Current"
    Display = "1"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.15"
    Max = "0.15"
    }
   -Wire-([90,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([90,1080],0,0,-1)
    {
    Name = "Ib"
    }
   0.pgb([126,1080],0,22733792,320)
    {
    Name = "Ib"
    Group = "Load Current"
    Display = "1"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.15"
    Max = "0.15"
    }
   -Wire-([90,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([90,1116],0,0,-1)
    {
    Name = "Ic"
    }
   0.pgb([126,1116],0,23802736,350)
    {
    Name = "Ic"
    Group = "Load Current"
    Display = "1"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.15"
    Max = "0.15"
    }
   -Wire-([90,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.ground([792,648],1,0,-1)
    {
    }
   0.resistor([792,576],1,0,-1)
    {
    R = "0.001 [ohm]"
    }
   0.ammeter([792,612],1,0,130)
    {
    Name = "Itg"
    }
   0.ground([792,828],0,0,-1)
    {
    }
   0.ammeter([756,828],0,0,250)
    {
    Name = "Iaf"
    }
   0.ground([72,576],1,0,-1)
    {
    }
   0.ammeter([72,540],1,0,40)
    {
    Name = "Isrc"
    }
   0.peswitch([486,1260],2,0,640)
    {
    L = "1"
    Type = "3"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch1c"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([522,1296],4,0,430)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id1c"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([486,1224],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([522,1260],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([522,1296],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([486,1296],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.peswitch([594,1260],2,0,610)
    {
    L = "3"
    Type = "3"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch3c"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([630,1296],4,0,440)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id3c"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([594,1224],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([630,1260],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([630,1296],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([594,1296],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.peswitch([486,1368],2,0,600)
    {
    L = "4"
    Type = "3"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch4c"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([522,1404],4,0,490)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id4c"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([522,1368],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([522,1404],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([486,1404],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.peswitch([594,1368],2,0,590)
    {
    L = "2"
    Type = "3"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch2c"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([630,1404],4,0,510)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id2c"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([630,1368],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([630,1404],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([594,1404],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([486,1224],0,0,-1)
    {
    Vertex="0,0;180,0"
    }
   -Wire-([486,1440],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   -Wire-([288,1332],0,0,-1)
    {
    Vertex="0,0;306,0"
    }
   0.peswitch([486,756],2,0,760)
    {
    L = "1"
    Type = "3"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch1a"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([522,792],4,0,210)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id1a"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([486,720],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([522,756],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([522,792],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([486,792],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.peswitch([594,756],2,0,750)
    {
    L = "3"
    Type = "3"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch3a"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([630,792],4,0,220)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id3a"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([594,720],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([630,756],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([630,792],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([594,792],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.peswitch([486,864],2,0,740)
    {
    L = "4"
    Type = "3"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch4a"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([522,900],4,0,270)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id4a"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([522,864],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([522,900],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([486,900],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.peswitch([594,864],2,0,730)
    {
    L = "2"
    Type = "3"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch2a"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([630,900],4,0,280)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id2a"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([630,864],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([630,900],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([594,900],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([486,720],0,0,-1)
    {
    Vertex="0,0;180,0"
    }
   -Wire-([486,936],0,0,-1)
    {
    Vertex="0,0;252,0"
    }
   -Wire-([396,846],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.datalabel([450,900],0,0,-1)
    {
    Name = "g4"
    }
   0.datalabel([450,792],0,0,-1)
    {
    Name = "g1"
    }
   -Wire-([396,828],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([738,720],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([738,900],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.peswitch([486,1008],2,0,720)
    {
    L = "1"
    Type = "3"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch1b"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([522,1044],4,0,330)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id1b"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([486,972],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([522,1008],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([522,1044],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([486,1044],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.peswitch([594,1008],2,0,710)
    {
    L = "3"
    Type = "3"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch3b"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([630,1044],4,0,340)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id3b"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([594,972],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([630,1008],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([630,1044],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([594,1044],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.peswitch([486,1116],2,0,700)
    {
    L = "4"
    Type = "3"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch4b"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([522,1152],4,0,380)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id4b"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([522,1116],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([522,1152],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([486,1152],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.peswitch([594,1116],2,0,690)
    {
    L = "2"
    Type = "3"
    SNUB = "1"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Iswtch2b"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   0.peswitch([630,1152],4,0,390)
    {
    L = ""
    Type = "0"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.0 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "5000.0 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = "Id2b"
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Wire-([630,1116],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([630,1152],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([594,1152],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([486,972],0,0,-1)
    {
    Vertex="0,0;180,0"
    }
   -Wire-([486,1188],0,0,-1)
    {
    Vertex="0,0;252,0"
    }
   -Wire-([324,1098],0,0,-1)
    {
    Vertex="0,0;162,0"
    }
   -Wire-([324,1080],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([252,1332],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.datalabel([90,1368],0,0,-1)
    {
    Name = "VLdc"
    }
   0.pgb([126,1368],0,23145712,450)
    {
    Name = "Vdc_load"
    Group = "DC Load"
    Display = "1"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-0.05"
    Max = "0.3"
    }
   -Wire-([90,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([90,1404],0,0,-1)
    {
    Name = "Idc"
    }
   0.pgb([126,1404],0,23148256,470)
    {
    Name = "Idc_load"
    Group = "DC Load"
    Display = "1"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.02"
    Max = "0.1"
    }
   -Wire-([90,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([918,324],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 918,324,1098,378
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "\
Load:
A 6 pulse rectifier as a source of harmonics"
    }
   -Sticky-([792,684],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 792,684,1098,774
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "\
Simplification:
A dc source has been put in the place of dc capacitor, it has simplified a control system of active filter"
    }
   -Sticky-([558,198],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 558,198,648,252
    Alignment = 0
    Style = 1
    Arrow = 194
    Color = 0,15792890
    Text = "\
Passive Filters:
5th, 7th and high-pass"
    }
   0.pgb([126,1188],0,23151696,680)
    {
    Name = "S1(1)"
    Group = "Gate Pulses"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([126,1224],0,23153608,670)
    {
    Name = "S1(2)"
    Group = "Gate Pulses"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([126,1260],0,23030240,650)
    {
    Name = "S4(1)"
    Group = "Gate Pulses"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([90,1278],4,0,-1)
    {
    Name = "G4"
    }
   0.datalabel([90,1206],0,0,-1)
    {
    Name = "G1"
    }
   0.pgb([126,1296],0,23033256,630)
    {
    Name = "S4(2)"
    Group = "Gate Pulses"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([558,522],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.pin([486,1350],4,0,-1)
    {
    }
   -Wire-([432,828],0,0,-1)
    {
    Vertex="0,0;162,0"
    }
   0.pin([594,828],0,0,-1)
    {
    }
   0.pin([486,846],0,0,-1)
    {
    }
   0.pin([594,1080],0,0,-1)
    {
    }
   0.pin([486,1098],0,0,-1)
    {
    }
   0.pin([594,1332],0,0,-1)
    {
    }
   0.pin([738,936],0,0,-1)
    {
    }
   0.pin([738,1188],0,0,-1)
    {
    }
   0.pin([666,972],0,0,-1)
    {
    }
   0.pin([666,720],0,0,-1)
    {
    }
   0.datatap([126,1224],0,0,660)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "0"
    }
   0.datatap([126,1296],0,0,620)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "0"
    }
   0.datatap([126,1188],6,0,570)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "0"
    }
   0.datatap([126,1260],6,0,580)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "0"
    }
   -Wire-([90,1206],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([90,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([738,828],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([72,540],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([90,882],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([126,720],0,24758616,160)
    {
    Name = "VAFa"
    Group = "Active Filter Voltage"
    Display = "1"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2"
    Max = "5"
    }
   .RunTime([90,306],0,0,10)
    {
    }
   -Sticky-([54,72],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 54,72,450,252
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
A simplified active filter in series configuration. The function of series active filter is not to directly compensate for harmonics, but to improve the filtering of the shunt passive filter.

Reference:
F.Z. Peng, H. Akagi and A.Nabe,
'A New Approach to Harmonic Compensation in Power Systems - A Combined System of  Shunt Passive and Series Active Filters', IEEE Trans. on Ind.Applications, vol.26, No.6, Nov/Dec 1990, pp. 983-990.
  "
    }
   .CtrlSystem([162,306],0,0,20)
    {
    }
   -Wire-([360,540],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Sticky-([36,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 36,18,1206,54
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "ACTIVE FILTER SERIES CONFIGURATION"
    }
   0.annotation([126,684],0,0,-1)
    {
    AL1 = "Active Filter Voltage"
    AL2 = ""
    }
   -Wire-([90,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.annotation([126,846],0,0,-1)
    {
    AL1 = "System Currents"
    AL2 = ""
    }
   0.annotation([126,1008],0,0,-1)
    {
    AL1 = "Load Currents"
    AL2 = ""
    }
   0.radiolink([990,1062],0,0,360)
    {
    Source = "Main"
    Name = "V"
    dim = "3"
    Mode = "1"
    Type = "0"
    }
   -Wire-([990,1062],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datalabel([972,1062],6,0,-1)
    {
    Name = "V"
    }
   0.datalabel([972,1098],2,0,-1)
    {
    Name = "ISa"
    }
   0.datalabel([972,1134],2,0,-1)
    {
    Name = "ISb"
    }
   0.datalabel([972,1170],2,0,-1)
    {
    Name = "ISc"
    }
   -Wire-([972,1098],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([972,1134],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([972,1170],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.radiolink([990,1098],0,0,370)
    {
    Source = "Main"
    Name = "ISa"
    dim = "1"
    Mode = "1"
    Type = "0"
    }
   0.radiolink([990,1134],0,0,400)
    {
    Source = "Main"
    Name = "ISb"
    dim = "1"
    Mode = "1"
    Type = "0"
    }
   0.radiolink([990,1170],0,0,420)
    {
    Source = "Main"
    Name = "ISc"
    dim = "1"
    Mode = "1"
    Type = "0"
    }
   0.datalabel([1080,1278],2,0,-1)
    {
    Name = "g1"
    }
   0.datalabel([1080,1386],2,0,-1)
    {
    Name = "g4"
    }
   0.datalabel([1080,1458],2,0,-1)
    {
    Name = "g6"
    }
   0.datalabel([1080,1350],2,0,-1)
    {
    Name = "g3"
    }
   0.datalabel([1080,1314],2,0,-1)
    {
    Name = "g2"
    }
   0.datalabel([1080,1422],2,0,-1)
    {
    Name = "g5"
    }
   -Wire-([1062,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1062,1314],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1062,1350],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1062,1386],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1062,1422],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([1062,1458],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.radiolink([1062,1278],4,0,460)
    {
    Source = "CtrlSystem"
    Name = "g1"
    dim = "2"
    Mode = "0"
    Type = "0"
    }
   0.radiolink([1062,1314],4,0,480)
    {
    Source = "CtrlSystem"
    Name = "g2"
    dim = "2"
    Mode = "0"
    Type = "0"
    }
   0.radiolink([1062,1350],4,0,500)
    {
    Source = "CtrlSystem"
    Name = "g3"
    dim = "2"
    Mode = "0"
    Type = "0"
    }
   0.radiolink([1062,1386],4,0,530)
    {
    Source = "CtrlSystem"
    Name = "g4"
    dim = "2"
    Mode = "0"
    Type = "0"
    }
   0.radiolink([1062,1422],4,0,550)
    {
    Source = "CtrlSystem"
    Name = "g5"
    dim = "2"
    Mode = "0"
    Type = "0"
    }
   0.radiolink([1062,1458],4,0,560)
    {
    Source = "CtrlSystem"
    Name = "g6"
    dim = "2"
    Mode = "0"
    Type = "0"
    }
   0.breakout([180,540],0,0,-1)
    {
    Dis = "0"
    }
   -Wire-([846,540],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.breakout([504,540],4,0,-1)
    {
    Dis = "0"
    }
   0.annotation([126,1152],0,0,-1)
    {
    AL1 = "Firing Pulses"
    AL2 = ""
    }
   0.annotation([126,1332],0,0,-1)
    {
    AL1 = "Rectifier DC load"
    AL2 = ""
    }
   0.annotation([126,1440],0,0,-1)
    {
    AL1 = "Active Filter DC side"
    AL2 = ""
    }
   0.ground([558,324],3,0,-1)
    {
    }
   0.ground([666,324],3,0,-1)
    {
    }
   0.annotation([918,1026],0,0,-1)
    {
    AL1 = "Exports"
    AL2 = ""
    }
   0.annotation([918,1242],0,0,-1)
    {
    AL1 = "Imports"
    AL2 = ""
    }
   0.voltmetergnd([666,540],0,0,70)
    {
    Name = "V"
    }
   0.inductor([396,792],1,0,-1)
    {
    L = "1 [mH]"
    }
   0.inductor([324,1044],1,0,-1)
    {
    L = "1 [mH]"
    }
   0.multimeter([1026,432],0,0,30)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "0"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = "Idc"
    VolI = "VLdc"
    P = ""
    Q = ""
    Vrms = ""
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([1044,432],0,0,-1)
    {
    Vertex="0,0;72,0;72,36"
    }
   -Sticky-([702,72],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 702,72,1098,162
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\

THIS CASE WILL NOT RUN ON THE STUDENT EDITION OF PSCAD BECAUSE IT HAS MORE THAN 15 NODES!  CONTACT support@pscad.com FOR MORE INFO.   "
    }
   0.unity([990,612],4,0,780)
    {
    IType = "2"
    OType = "1"
    }
   0.emtconst([1026,540],4,0,110)
    {
    Name = "deg. to rad."
    Value = "5"
    }
   0.mult([990,576],2,0,790)
    {
    }
   }
  }
 }

